## File Descriptions

This file provides an overview of the real-world tampering parameters we collected, including multi-format logs (e.g., video, PSD, and editing logs). These materials document the entire image tampering process carried out manually using Adobe Photoshop by an experienced editor. The files aim to give reviewers a clear understanding of the editing steps and the tampering operations applied, ensuring transparency in how the tampered images were generated. This specific example corresponds to a replacement operation, where a part of the original image is replaced with new content.

### `550_item.png`
This is the **original untampered image**. It serves as the base image for the tampering process.

### `550_item_tamper.png`
This is the **tampered version** of the original image. All modifications were performed manually using Adobe Photoshop by an experienced editor, simulating realistic image forgery.

### `550_item_mask.png`
This is the **binary tampering mask** corresponding to `550_item_tamper.png`.  
- Tampered regions are marked in **white** .
- Untampered regions are marked in **black** .

The mask provides pixel-level supervision for training and evaluating tampering detection models.

### `550_item.mp4`
This video captures the **screen recording** of the entire tampering process. It provides valuable insight into how the manipulations were performed in practice and reflects real-world editing behavior.

### `550_item.psd`
This is the Photoshop project file used during the tampering process. It contains all layers, editing history, and adjustments made to the original image, providing full transparency of the editing steps. The PSD file enables the exact reconstruction of the tampered image, and serves as a comprehensive record of the changes made during the tampering process.

### `550_item.txt`
This text file contains the **operation log** exported from Photoshop, documenting the editing steps taken during the tampering process. Some sensitive content has been redacted or anonymized for privacy and compliance purposes.